﻿using System;
using System.Collections.Generic;
using VIRP.CRS.BO;
using VIRP.CRS.DAL;
using VIRP.ViaService;

namespace VIRP.CRS.BLL
{
    public static class ViaManager
    {
        public static ViaPerson CPRSLaunch(string CURRENT_USER, string duz, string dfn, string loginSiteCode)
        {
            ViaDb objDb = new ViaDb();

            ViaPerson persons = objDb.CPRSLaunch(CURRENT_USER, duz, dfn, loginSiteCode);

            return persons;
        }

        public static List<StringKeyValuePair> GetNoteTitles(string CURRENT_USER, string target, string direction, out string error, string loginSiteCode, string dfn, string duz, string providerName)
        {
            ViaDb objDb = new ViaDb();

            List<StringKeyValuePair> result = objDb.GetNoteTitles(CURRENT_USER, target, direction, out error, loginSiteCode, dfn, duz, providerName);

            return result;
        }

        public static List<StringKeyValuePair> GetLocations(string CURRENT_USER, string searchParameter, string direction, out string error, string loginSiteCode, string dfn, string providerName, string duz)
        {
            ViaDb objDb = new ViaDb();

            List<StringKeyValuePair> result = objDb.GetLocations(CURRENT_USER, searchParameter, direction, out error, loginSiteCode, dfn, providerName, duz);

            return result;
        }

        public static List<StringKeyValuePair> GetConsults(string CURRENT_USER, out string error, string loginSiteCode, string dfn, string providerName, string duz)
        {
            ViaDb objDb = new ViaDb();

            List<StringKeyValuePair> result = objDb.GetConsults(CURRENT_USER, out error, loginSiteCode, dfn, providerName, duz);

            return result;
        }

        public static List<StringKeyValuePair> GetHospitalAdmissions(string CURRENT_USER, out string error, string loginSiteCode, string dfn, string providerName, string duz, string patientIcn)
        {
            ViaDb objDb = new ViaDb();

            List<StringKeyValuePair> result = objDb.GetHospitalAdmissions(CURRENT_USER, out error, loginSiteCode, dfn, providerName, duz, patientIcn);

            return result;
        }

        public static List<StringKeyValuePair> GetVisits(string CURRENT_USER, DateTime fromDate, DateTime toDate, out string error, string loginSiteCode, string dfn, string providerName, string duz, string patientIcn)
        {
            ViaDb objDb = new ViaDb();

            List<StringKeyValuePair> result = objDb.GetVisits(CURRENT_USER, fromDate, toDate, out error, loginSiteCode, dfn, providerName, duz, patientIcn);

            return result;
        }

        public static string WriteNote(string CURRENT_USER, string titleIEN, string encounterString, string noteText, string authorDUZ, string cosignerDUZ, string consultIEN, string prfIEN, string loginSiteCode, string dfn, string providerName, string duz)
        {
            ViaDb objDb = new ViaDb();

            string result = objDb.WriteNote(CURRENT_USER, titleIEN, encounterString, noteText, authorDUZ, cosignerDUZ, consultIEN, prfIEN, loginSiteCode, dfn, providerName, duz);

            return result;
        }
    }
}
